//ΒΑΘΜΟΝΟΜΗΣΗ ΘΕΡΜΟΜΕΤΡΟΥ//

#include <Liquid_Crystal.h>  //Βιβλιοθήκη οθόνης
#include <Potentiometer.h>   //Βιβλιοθήκη ποτενσιομέτρου
#include <Temp.h>            //Βιβλιοθήκη θερμομέτρου


LiquidCrystal myLCD(0x27, 16, 2);   // Δήλωση διεύθυνσης της οθόνης. Η σύνδεση θα πρέπει να γίνει στη θύρα I2C


Temp myTemp(9);    // Δήλωση της θύρας του θερμομέτρου


int potPort = A0;  // Δήλωση της θύρας του ποτενσιόμετρου


float potMin = -10.00; //Δήλωση μεταβλητής με την ελάχιστη τιμή του ποτενσιομέτρου
float potMax = 10.00;  //Δήλωση μεταβλητής με την μέγιστη τιμή του ποτενσιομέτρου
float calib=0.00;      //Δήλωση μεταβλητής για την αποθήκευση της τιμής του ποτενσιομέτρου παρακάτω στον κώδικα


Potentiometer myPot(potPort, potMin, potMax); // Έναρξη ποτενσιομέτρου

void setup() {
  myLCD.begin();   // Έναρξη LCD
  myTemp.begin();  // Έναρξη θερμομέτρου
}

void loop() {

   calib = myPot.read();  // Ανάγνωση του ποτενσιομέτρου

   float temperature = myTemp.readTemperature(); // Δήλωση μεταβλητής temperature και ανάγνωση θερμοκρασίας

   float tempr_calibrated = temperature+calib;  // ΒΑΘΜΟΝΟΜΗΣΗ: Δήλωση μεταβλητής tempr_calibrated η οποία είναι το άθροισμα της θερμοκρασίας και της τιμής του ποτενσιομέτρου
    
    myLCD.Text("Temp=", 0, 0); // Εμφάνιση κειμένου στην οθόνη από την στήλη 1 και γραμμή 1
    
    myLCD.Text(String(tempr_calibrated,2).c_str(), 5, 0); // Εμφάνιση "βαθμονομημένης" θερμοκρασίας στην οθόνη με 2 δεκαδιακά ψηφία, από τη στήλη 6 και γραμμή 1
    
    delay(500);
}
